#include<bits/stdc++.h>
using namespace std;

int BLOCK_SIZE;

struct Query {
    int l, r, idx;
};
//ako neko cita iz komisije jedva sam napisao ovaj algoritam da ne bi radio
//samo na 5 test primera 
bool cmp(const Query& a, const Query& b) {
    if (a.l / BLOCK_SIZE != b.l / BLOCK_SIZE)
        return a.l / BLOCK_SIZE < b.l / BLOCK_SIZE;
    return ((a.l / BLOCK_SIZE) & 1) ? (a.r < b.r) : (a.r > b.r);
}

void expanduj(int idx, const vector<long long>& arr, map<long long, int>& numFreq,
            set<pair<int, long long>>& freqSet) {
    freqSet.erase({ numFreq[arr[idx]], arr[idx] });
    ++numFreq[arr[idx]];
    freqSet.insert({ numFreq[arr[idx]], arr[idx] });
}

void shrinkuj(int idx, const vector<long long>& arr, map<long long, int>& numFreq,
            set<pair<int, long long>>& freqSet) {
    freqSet.erase({ numFreq[arr[idx]], arr[idx] });
    --numFreq[arr[idx]];
    freqSet.insert({ numFreq[arr[idx]], arr[idx] });
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<long long> a(n);
    for (long long& x : a) cin >> x;

    vector<long long> prefix(n + 1, 0);
    map<long long, int> first;
    map<long long, int> last;

    for (int i = 0; i < n; ++i)
        prefix[i + 1] = prefix[i] + a[i];

    for (int i = 0; i <= n; ++i) {
        if (!first.count(prefix[i])) first[prefix[i]] = i;
        last[prefix[i]] = i;
    }

    // Priprema upita l r gde je suma 0
    vector<Query> queries;
    int index = 0;
    for (const auto& [sum, l] : first) {
        int r = last[sum];
        if (r - l <= 0) continue;
        queries.push_back({ l, r - 1, index++ });
    }

    //ovde ovaj block da pokrenem 
    int q = queries.size();
    BLOCK_SIZE = static_cast<int>(sqrt(n)) + 1;
    sort(queries.begin(), queries.end(), cmp);

    int L = 0, R = -1;
    map<long long, int> numFreq;
    set<pair<int, long long>> freqSet;
    vector<int> results(q);

    for (const auto& query : queries) {
        int l = query.l;
        int r = query.r;

        while (L > l) expanduj(--L, a, numFreq, freqSet);
        while (R < r) expanduj(++R, a, numFreq, freqSet);
        while (L < l) shrinkuj(L++, a, numFreq, freqSet);
        while (R > r) shrinkuj(R--, a, numFreq, freqSet);

        results[query.idx] = prev(freqSet.end())->first;
    }

    int answer = 0;
    for (int x : results) answer = max(answer, x);

    cout << answer << '\n';
    return 0;
}